<?php
session_start();
include('includes/config.php');

// SenangPay Setup
$merchant_id = '907174582234337'; // Replace with your merchant ID
$secret_key = 'SK-DyAPpleHrrjf7uKAxsmf'; // Replace with your actual secret key

// Get and decode URL parameters
$bid = base64_decode($_GET['bid']);
$eml = base64_decode($_GET['eml']);
$pno = base64_decode($_GET['pno']);

// Get booking details
$query = mysqli_query($con, "SELECT tblbookings.*, tblboat.ID as BoatID, tblboat.BoatName 
                             FROM tblbookings 
                             JOIN tblboat ON tblboat.ID = tblbookings.BoatID  
                             WHERE tblbookings.ID='$bid' AND tblbookings.EmailId='$eml' AND tblbookings.PhoneNumber='$pno'");
$result = mysqli_fetch_array($query);

// Payment details
$detail = 'Bayaran Tempahan Fasiliti ' . $result['BookingNumber'];
$amount = $result['AdminRemark']; // Optionally make this dynamic
$order_id = $result['BookingNumber'];

// Hash must be plain text (no urlencode or urldecode)
$hashed_string = md5($secret_key . $detail . $amount . $order_id);

// Build SenangPay URL
$payment_url = "https://app.senangpay.my/payment/$merchant_id?" .
               "detail=" . urlencode($detail) .
               "&amount=" . urlencode($amount) .
               "&order_id=" . urlencode($order_id) .
               "&hash=" . $hashed_string .
               "&name=" . urlencode($result['FullName']) .
               "&email=" . urlencode($result['EmailId']) .
               "&phone=" . urlencode($result['PhoneNumber']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Status Tempahan</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Styles -->
  <link href="https://fonts.googleapis.com/css?family=Oswald:400,700|Dancing+Script:400,700|Muli:300,400" rel="stylesheet">
  <link rel="stylesheet" href="fonts/icomoon/style.css">
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/jquery-ui.css">
  <link rel="stylesheet" href="css/owl.carousel.min.css">
  <link rel="stylesheet" href="css/jquery.fancybox.min.css">
  <link rel="stylesheet" href="css/bootstrap-datepicker.css">
  <link rel="stylesheet" href="fonts/flaticon/font/flaticon.css">
  <link rel="stylesheet" href="css/aos.css">
  <link href="css/jquery.mb.YTPlayer.min.css" media="all" rel="stylesheet" type="text/css">
  <link rel="stylesheet" href="css/style.css">
</head>

<body>
<div class="site-wrap">
  <?php include_once("includes/navbar.php"); ?>

  <div class="site-section">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <table class="table table-bordered">
            <tbody>
              <tr><th>No Tempahan</th><td colspan="3"><?php echo $result['BookingNumber']; ?></td></tr>
              <tr><th>Nama</th><td><?php echo $result['FullName']; ?></td><th>Email</th><td><?php echo $result['EmailId']; ?></td></tr>
              <tr><th>No Telefon</th><td><?php echo $result['PhoneNumber']; ?></td><th>Peralatan</th><td><?php echo $result['Notes']; ?></td></tr>
              <tr><th>Tempoh Tempahan</th><td><?php echo $result['BookingDateFrom']; ?> hingga <?php echo $result['BookingDateTo']; ?></td>
                  <th>Masa</th><td><?php echo $result['BookingTime']; ?></td></tr>
              <tr><th>Tarikh Pos</th><td><?php echo $result['postingDate']; ?></td>
                  <th>Nama Dewan</th><td><?php echo $result['BoatName']; ?> <a href="boat-details.php?bid=<?php echo $result['BoatID']; ?>" target="_blank">Lihat Butiran</a></td></tr>
              <tr><th>Status</th><td>
                <?php
                  if ($result['BookingStatus'] == '') echo '<span class="badge bg-warning text-dark">Belum Diproses</span>';
                  elseif ($result['BookingStatus'] == 'Accepted') echo '<span class="badge bg-success">Diterima</span>';
                  elseif ($result['BookingStatus'] == 'Rejected') echo '<span class="badge bg-danger">Ditolak</span>';
                ?>
              </td>
              <th>Kemaskini</th><td><?php echo $result['UpdationDate']; ?></td></tr>
              <tr><th>Ulasan Admin</th><td colspan="3"> Sila buat bayaran secara atas talian sebanyak RM<?php echo $result['AdminRemark']; ?> tunai. </td></tr>
            </tbody>
          </table>

          <div class="text-center mt-4">
            <a href="<?php echo $payment_url; ?>" class="btn btn-primary btn-lg">Sila Bayar Disini</a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="site-section bg-image overlay" style="background-image: url('images/bg.png');">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-7 text-center">
          <h2 class="text-white">Sila Hubungi Kami</h2>
          <p><a href="contact.php" class="btn btn-warning py-3 px-5 text-white">Talian</a></p>
        </div>
      </div>
    </div>
  </div>

  <?php include_once("includes/footer.php"); ?>
</div>

<!-- Scripts -->
<script src="js/jquery-3.3.1.min.js"></script>
<script src="js/jquery-migrate-3.0.1.min.js"></script>
<script src="js/jquery-ui.js"></script>
<script src="js/popper.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/owl.carousel.min.js"></script>
<script src="js/jquery.stellar.min.js"></script>
<script src="js/jquery.countdown.min.js"></script>
<script src="js/bootstrap-datepicker.min.js"></script>
<script src="js/jquery.easing.1.3.js"></script>
<script src="js/aos.js"></script>
<script src="js/jquery.fancybox.min.js"></script>
<script src="js/jquery.sticky.js"></script>
<script src="js/jquery.mb.YTPlayer.min.js"></script>
<script src="js/main.js"></script>

</body>
</html>
